<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name');
			$table->string('last_name');
			$table->string('email')->unique();
			$table->string('phone_number')->unique();
			$table->tinyInteger('status')->unsigned();
			$table->bigInteger('country_code_id')->unsigned();
			$table->string('last_login_ip', 45)->nullable();
			$table->timestamp('last_login_at');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}