<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('computers', function(Blueprint $table) {
			$table->foreign('computer_status_id')->references('id')->on('computer_statuses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('work_orders', function(Blueprint $table) {
			$table->foreign('work_order_status_id')->references('id')->on('work_order_statuses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('work_order_computers', function(Blueprint $table) {
			$table->foreign('work_order_id')->references('id')->on('work_orders')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('work_order_computers', function(Blueprint $table) {
			$table->foreign('computer_id')->references('id')->on('computers')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('computers', function(Blueprint $table) {
			$table->dropForeign('computers_computer_status_id_foreign');
		});
		Schema::table('work_orders', function(Blueprint $table) {
			$table->dropForeign('work_orders_work_order_status_id_foreign');
		});
		Schema::table('work_order_computers', function(Blueprint $table) {
			$table->dropForeign('work_order_computers_work_order_id_foreign');
		});
		Schema::table('work_order_computers', function(Blueprint $table) {
			$table->dropForeign('work_order_computers_computer_id_foreign');
		});
	}
}