<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTracksTable extends Migration {

	public function up()
	{
		Schema::create('tracks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->bigIncrements('album_id');
			$table->string('duration');
			$table->string('format');
			$table->date('release_date');
			$table->string('track_img');
			$table->mediumText('description');
			$table->integer('total_rating');
			$table->decimal('avg_rating');
			$table->integer('review_count');
			$table->bigIncrements('added_by_user_id');
			$table->string('added_by');
			$table->bigIncrements('updated_by_user_id');
			$table->string('updated_by');
		});
	}

	public function down()
	{
		Schema::drop('tracks');
	}
}