<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAlbumsTable extends Migration {

	public function up()
	{
		Schema::create('albums', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 1000);
			$table->mediumText('description');
			$table->date('release_date');
			$table->string('format');
			$table->string('duration');
			$table->string('cover_pic');
			$table->string('added_by');
			$table->bigIncrements('updated_by_user_id');
			$table->string('updated_by');
			$table->boolean('is_active');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('albums');
	}
}