<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 1000);
			$table->string('username', 1000)->index();
			$table->string('email')->index();
			$table->string('mobile')->unique();
			$table->datetime('email_verified_at');
			$table->string('password');
			$table->string('gender');
			$table->mediumText('bio');
			$table->string('profile_pic');
			$table->decimal('reviews_count')->default('0');
			$table->decimal('ratings_count')->default('0');
			$table->decimal('favorites_count')->default('0');
			$table->decimal('likes_count');
			$table->string('followers_count');
			$table->decimal('following_count');
			$table->boolean('status');
			$table->datetime('sent_email_time');
			$table->longText('remember_token');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}