<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArtistsTable extends Migration {

	public function up()
	{
		Schema::create('artists', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 1000);
			$table->longText('bio');
			$table->string('profile_img_path', 1000);
			$table->mediumText('cover_pic')->nullable();
			$table->float('total_ratings', 8,2)->nullable();
			$table->float('avg_ratings', 8,2);
			$table->bigIncrements('added_by_user_id');
			$table->string('added_by');
			$table->bigIncrements('updated_by_user_id');
			$table->string('updated_by');
			$table->boolean('is_active')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('artists');
	}
}