<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username', 64);
			$table->string('user_sendgrid', 75);
			$table->string('password', 255);
			$table->string('pass', 40);
			$table->string('code', 255);
			$table->string('email', 64)->nullable();
			$table->string('first_name', 50)->nullable();
			$table->string('last_name', 50)->nullable();
			$table->string('address', 100)->nullable();
			$table->string('city', 100)->nullable();
			$table->string('state', 100)->nullable();
			$table->string('zip', 15)->nullable();
			$table->string('country', 2)->nullable();
			$table->string('website', 255)->nullable();
			$table->string('phone', 12)->nullable();
			$table->string('company', 255)->nullable();
			$table->string('mail_domain', 255)->nullable();
			$table->binary('disabled');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}