<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function senders()
    {
        return $this->hasMany('Sender', 'user_id');
    }

    public function listas()
    {
        return $this->hasMany('Lista', 'user_id');
    }

    public function mytemplates()
    {
        return $this->hasMany('MyTemplate', 'user_id');
    }

    public function marketings()
    {
        return $this->hasMany('Marketing', 'user_id');
    }

    public function unsubscribes()
    {
        return $this->hasMany('Unsubscribe', 'user_id');
    }

    public function domains()
    {
        return $this->hasMany('Domain', 'user_id');
    }

    public function ips()
    {
        return $this->belongsToMany('Ip');
    }

}