<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommentTable extends Migration {

	public function up()
	{
		Schema::create('comment', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('task_id')->index();
			$table->integer('user_id')->index();
			$table->string('title', 255);
			$table->text('comment')->default('NULL');
			$table->string('url', 255)->default('NULL');
			$table->string('file', 255);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('comment');
	}
}