<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExamsTable extends Migration {

	public function up()
	{
		Schema::create('exams', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('image')->nullable();
			$table->string('title');
			$table->longText('description');
			$table->longText('rang');
		});
	}

	public function down()
	{
		Schema::drop('exams');
	}
}