<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'doctor_id', 'admin_commission_per', 'admin_commission', 'total', 'final_total', 'status', 'pay_type', 'pay_status', 'pay_data', 'room_id', 'is_rate');

	public function doctor()
	{
		return $this->belongsTo('App\Models\Doctor');
	}

	public function user()
	{
		return $this->belongsTo('App\Models\Users');
	}

}