<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class WorkDay extends Eloquent {

	protected $table = 'work_days';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('from', 'to', 'day', 'doctor_id');

	public function doctor()
	{
		return $this->belongsTo('App\Models\Doctor');
	}

}