<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('country_code', 5);
			$table->string('phone')->unique();
			$table->integer('code')->nullable();
			$table->datetimeTz('code_expire')->nullable();
			$table->string('lang');
			$table->decimal('wallet_balance', 9,2)->nullable();
			$table->boolean('is_notify')->default(1);
			$table->boolean('is_approved')->default(1);
			$table->boolean('is_blocked')->default(0);
			$table->string('password');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}