<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Questionnaire extends Model 
{

    protected $table = 'Questionnaire';
    public $timestamps = true;
    protected $fillable = array('published', 'valid_from', 'valid_to', 'name', 'description');

    public function questions()
    {
        return $this->hasMany('Question');
    }

    public function answers()
    {
        return $this->hasMany('Answer');
    }

    public function preview_urls()
    {
        return $this->hasMany('Preview_Questionnaire');
    }

    public function rule()
    {
        return $this->hasMany('Questionnaire_rule');
    }

}