<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Question', function(Blueprint $table) {
			$table->foreign('question_type')->references('id')->on('Question_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Question', function(Blueprint $table) {
			$table->foreign('questionnaire_id')->references('id')->on('Questionnaire')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Question_answers', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('Question')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Answer', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('Question')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Answer', function(Blueprint $table) {
			$table->foreign('multi_answer')->references('id')->on('Question_answers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Answer', function(Blueprint $table) {
			$table->foreign('questionnaire_id')->references('id')->on('Questionnaire')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Answer', function(Blueprint $table) {
			$table->foreign('answered_questionnaire_id')->references('id')->on('Answered_Questionnaires')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Answered_Questionnaires', function(Blueprint $table) {
			$table->foreign('respondent_id')->references('id')->on('respondent')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Preview_Questionnaire', function(Blueprint $table) {
			$table->foreign('questionnaire_id')->references('id')->on('Questionnaire')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Questionnaire_rule', function(Blueprint $table) {
			$table->foreign('if_question_id')->references('id')->on('Question')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Questionnaire_rule', function(Blueprint $table) {
			$table->foreign('if_answer_id')->references('id')->on('Question_answers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Questionnaire_rule', function(Blueprint $table) {
			$table->foreign('then_question_id')->references('id')->on('Question')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Questionnaire_rule', function(Blueprint $table) {
			$table->foreign('then_answer_id')->references('id')->on('Question_answers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Questionnaire_rule', function(Blueprint $table) {
			$table->foreign('questionnaire_id')->references('id')->on('Questionnaire')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Questionnaire_rule_action', function(Blueprint $table) {
			$table->foreign('rule_id')->references('id')->on('Questionnaire_rule')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Questionnaire_rule_action', function(Blueprint $table) {
			$table->foreign('action_id')->references('id')->on('Questionnaire_rules_action')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Question_question_type', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('Question')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Question_question_type', function(Blueprint $table) {
			$table->foreign('question_type_id')->references('id')->on('Question_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('Question', function(Blueprint $table) {
			$table->dropForeign('Question_question_type_foreign');
		});
		Schema::table('Question', function(Blueprint $table) {
			$table->dropForeign('Question_questionnaire_id_foreign');
		});
		Schema::table('Question_answers', function(Blueprint $table) {
			$table->dropForeign('Question_answers_question_id_foreign');
		});
		Schema::table('Answer', function(Blueprint $table) {
			$table->dropForeign('Answer_question_id_foreign');
		});
		Schema::table('Answer', function(Blueprint $table) {
			$table->dropForeign('Answer_multi_answer_foreign');
		});
		Schema::table('Answer', function(Blueprint $table) {
			$table->dropForeign('Answer_questionnaire_id_foreign');
		});
		Schema::table('Answer', function(Blueprint $table) {
			$table->dropForeign('Answer_answered_questionnaire_id_foreign');
		});
		Schema::table('Answered_Questionnaires', function(Blueprint $table) {
			$table->dropForeign('Answered_Questionnaires_respondent_id_foreign');
		});
		Schema::table('Preview_Questionnaire', function(Blueprint $table) {
			$table->dropForeign('Preview_Questionnaire_questionnaire_id_foreign');
		});
		Schema::table('Questionnaire_rule', function(Blueprint $table) {
			$table->dropForeign('Questionnaire_rule_if_question_id_foreign');
		});
		Schema::table('Questionnaire_rule', function(Blueprint $table) {
			$table->dropForeign('Questionnaire_rule_if_answer_id_foreign');
		});
		Schema::table('Questionnaire_rule', function(Blueprint $table) {
			$table->dropForeign('Questionnaire_rule_then_question_id_foreign');
		});
		Schema::table('Questionnaire_rule', function(Blueprint $table) {
			$table->dropForeign('Questionnaire_rule_then_answer_id_foreign');
		});
		Schema::table('Questionnaire_rule', function(Blueprint $table) {
			$table->dropForeign('Questionnaire_rule_questionnaire_id_foreign');
		});
		Schema::table('Questionnaire_rule_action', function(Blueprint $table) {
			$table->dropForeign('Questionnaire_rule_action_rule_id_foreign');
		});
		Schema::table('Questionnaire_rule_action', function(Blueprint $table) {
			$table->dropForeign('Questionnaire_rule_action_action_id_foreign');
		});
		Schema::table('Question_question_type', function(Blueprint $table) {
			$table->dropForeign('Question_question_type_question_id_foreign');
		});
		Schema::table('Question_question_type', function(Blueprint $table) {
			$table->dropForeign('Question_question_type_question_type_id_foreign');
		});
	}
}