<?php

namespace  App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Achive extends Eloquent {

	protected $table = 'achive';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function utilisateur()
	{
		return $this->belongsTo(' App\Models\Utilisateur', 'utilisateur_id');
	}

	public function courriers()
	{
		return $this->hasMany(' App\Models\Courrier');
	}

}