<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lessons extends Model 
{

    protected $table = 'lessons';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function difficulty()
    {
        return $this->hasOne('Difficulties', 'difficulty_id');
    }

    public function templates()
    {
        return $this->hasMany('App\CourseTemplates');
    }

    public function feedbacks()
    {
        return $this->hasOne('App\LessonFeedbacks');
    }

}