<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Courses extends Eloquent {

	protected $table = 'courses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function template()
	{
		return $this->hasOne('App\CourseTemplates', 'template_id');
	}

	public function instructor()
	{
		return $this->hasOne('App\Users', 'instructor_id');
	}

	public function courseClass()
	{
		return $this->hasOne('App\Users', 'course_class_id');
	}

}