<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('role_id')->unsigned();
			$table->string('email')->unique()->nullable()->default('null');
			$table->string('password')->nullable()->default('NULL');
			$table->string('first_name');
			$table->string('last_name');
			$table->string('phone', 20);
			$table->boolean('active');
			$table->timestamps();
			$table->rememberToken();
			$table->softDeletes();
			$table->integer('course_class_id')->unsigned()->nullable()->default('null');
			$table->integer('agent_id')->unsigned()->nullable()->default('null');
			$table->string('api_token', 60)->unique()->nullable()->default('null');
			$table->integer('avatar_id')->unsigned();
			$table->string('nickname')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}