<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('course_class_id')->references('id')->on('course_classes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('agent_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('avatar_id')->references('id')->on('avatars')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('course_templates', function(Blueprint $table) {
			$table->foreign('difficulty_id')->references('id')->on('difficulties')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('course_templates', function(Blueprint $table) {
			$table->foreign('agent_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('course_agent_templates', function(Blueprint $table) {
			$table->foreign('template_id')->references('id')->on('course_templates')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('course_agent_templates', function(Blueprint $table) {
			$table->foreign('agent_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('course_classes', function(Blueprint $table) {
			$table->foreign('institute_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('template_id')->references('template_id')->on('course_agent_templates')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('instructor_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('course_class_id')->references('id')->on('course_classes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->foreign('difficulty_id')->references('id')->on('difficulties')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('course_lessons', function(Blueprint $table) {
			$table->foreign('course_template_id')->references('id')->on('course_templates')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('course_lessons', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('lesson_feedbacks', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('lesson_feedbacks', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('lesson_outputs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('lesson_outputs', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('lesson_outputs', function(Blueprint $table) {
			$table->foreign('rate_id')->references('id')->on('rates')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_course_class_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_agent_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_avatar_id_foreign');
		});
		Schema::table('course_templates', function(Blueprint $table) {
			$table->dropForeign('course_templates_difficulty_id_foreign');
		});
		Schema::table('course_templates', function(Blueprint $table) {
			$table->dropForeign('course_templates_agent_id_foreign');
		});
		Schema::table('course_agent_templates', function(Blueprint $table) {
			$table->dropForeign('course_agent_templates_template_id_foreign');
		});
		Schema::table('course_agent_templates', function(Blueprint $table) {
			$table->dropForeign('course_agent_templates_agent_id_foreign');
		});
		Schema::table('course_classes', function(Blueprint $table) {
			$table->dropForeign('course_classes_institute_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_template_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_instructor_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_course_class_id_foreign');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->dropForeign('lessons_difficulty_id_foreign');
		});
		Schema::table('course_lessons', function(Blueprint $table) {
			$table->dropForeign('course_lessons_course_template_id_foreign');
		});
		Schema::table('course_lessons', function(Blueprint $table) {
			$table->dropForeign('course_lessons_lesson_id_foreign');
		});
		Schema::table('lesson_feedbacks', function(Blueprint $table) {
			$table->dropForeign('lesson_feedbacks_user_id_foreign');
		});
		Schema::table('lesson_feedbacks', function(Blueprint $table) {
			$table->dropForeign('lesson_feedbacks_lesson_id_foreign');
		});
		Schema::table('lesson_outputs', function(Blueprint $table) {
			$table->dropForeign('lesson_outputs_user_id_foreign');
		});
		Schema::table('lesson_outputs', function(Blueprint $table) {
			$table->dropForeign('lesson_outputs_lesson_id_foreign');
		});
		Schema::table('lesson_outputs', function(Blueprint $table) {
			$table->dropForeign('lesson_outputs_rate_id_foreign');
		});
	}
}