<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('fullname', 255);
			$table->string('slug', 255)->nullable();
			$table->string('email', 255);
			$table->string('password');
			$table->string('timezone')->nullable();
			$table->string('avatar')->nullable();
			$table->string('phone')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}