<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('logo')->nullable();
			$table->string('slug')->nullable();
			$table->integer('user_id')->unsigned();
			$table->integer('employee_size')->nullable();
			$table->enum('visibility', array(''INTERNAL'', ''EXTERNAL'', ''BOTH''));
			$table->string('description')->nullable();
			$table->string('support_email');
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}