<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticleSuggestionsTable extends Migration {

	public function up()
	{
		Schema::create('article_suggestions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('article_id')->unsigned();
			$table->string('suggestions')->nullable();
			$table->string('name')->nullable();
			$table->string('email');
		});
	}

	public function down()
	{
		Schema::drop('article_suggestions');
	}
}