<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSearchAnalyticsTable extends Migration {

	public function up()
	{
		Schema::create('search_analytics', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('query');
			$table->boolean('found')->default(0);
			$table->boolean('read');
			$table->boolean('bounced');
		});
	}

	public function down()
	{
		Schema::drop('search_analytics');
	}
}