<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdressesTable extends Migration {

	public function up()
	{
		Schema::create('adresses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned();
			$table->timestamps();
			$table->enum('type', array('Domicile', 'Travail'));
			$table->string('batiment', 250);
			$table->string('adresse', 250);
			$table->string('codepostal', 5);
			$table->string('ville', 100);
		});
	}

	public function down()
	{
		Schema::drop('adresses');
	}
}