<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientProfessionTable extends Migration {

	public function up()
	{
		Schema::create('client_profession', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned();
			$table->integer('profession_id')->unsigned();
			$table->timestamps();
			$table->date('debut');
			$table->date('fin');
			$table->string('societe', 100);
			$table->string('adresse', 150);
			$table->string('codepostal');
			$table->string('ville', 75);
			$table->enum('type', array('CDI', 'CDD', 'Alternance', 'Interim', 'Stage', 'Chomage'));
		});
	}

	public function down()
	{
		Schema::drop('client_profession');
	}
}