<?php

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	public function regimes()
	{
		return $this->belongsToMany('Regime');
	}

	public function professions()
	{
		return $this->belongsToMany('Profession');
	}

	public function parentes()
	{
		return $this->hasMany('Parente');
	}

	public function adresses()
	{
		return $this->hasMany('Adresse');
	}

	public function courriels()
	{
		return $this->hasMany('Courriel');
	}

	public function telephones()
	{
		return $this->hasMany('Telephone');
	}

	public function partenaire()
	{
		return $this->belongsTo('Partenaire');
	}

	public function compterendus()
	{
		return $this->hasMany('Compterendu');
	}

	public function biens()
	{
		return $this->belongsToMany('Bien');
	}

	public function affectations()
	{
		return $this->hasMany('Affectation');
	}

	public function passifs()
	{
		return $this->hasManyThrough('Passif', 'Affectation');
	}

	public function actifs()
	{
		return $this->hasManyThrough('Actif', 'Affectation');
	}

	public function tresoreries()
	{
		return $this->hasManyThrough('Tresorerie', 'Affectation');
	}

}