<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('partenaire_id')->references('id')->on('partenaires')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('conseiller_pret', function(Blueprint $table) {
			$table->foreign('pret_id')->references('id')->on('prets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('conseiller_pret', function(Blueprint $table) {
			$table->foreign('conseiller_id')->references('id')->on('conseillers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('compterendus', function(Blueprint $table) {
			$table->foreign('sujet_id')->references('id')->on('sujets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('compterendus', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('compterendus', function(Blueprint $table) {
			$table->foreign('partenaire_id')->references('id')->on('partenaires')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('telephones', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('adresses', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('affectations', function(Blueprint $table) {
			$table->foreign('passif_id')->references('id')->on('passifs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('affectations', function(Blueprint $table) {
			$table->foreign('actif_id')->references('id')->on('actifs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('affectations', function(Blueprint $table) {
			$table->foreign('tresorerie_id')->references('id')->on('tresoreries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('affectations', function(Blueprint $table) {
			$table->foreign('id_client')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('parentes', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('client_regime', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('client_regime', function(Blueprint $table) {
			$table->foreign('regime_id')->references('id')->on('regimes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('client_profession', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('client_profession', function(Blueprint $table) {
			$table->foreign('profession_id')->references('id')->on('professions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('courriels', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('perimetres', function(Blueprint $table) {
			$table->foreign('conseiller_id')->references('id')->on('conseillers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bien_client', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bien_client', function(Blueprint $table) {
			$table->foreign('bien_id')->references('id')->on('biens')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('conseillers', function(Blueprint $table) {
			$table->foreign('preteur_id')->references('id')->on('preteurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notaires', function(Blueprint $table) {
			$table->foreign('etude_id')->references('id')->on('etudes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('prets', function(Blueprint $table) {
			$table->foreign('bien_id')->references('id')->on('biens')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('passifs', function(Blueprint $table) {
			$table->foreign('actif_id')->references('id')->on('actifs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tresoreries', function(Blueprint $table) {
			$table->foreign('actif_id')->references('id')->on('actifs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tresoreries', function(Blueprint $table) {
			$table->foreign('passif_id')->references('id')->on('passifs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_partenaire_id_foreign');
		});
		Schema::table('conseiller_pret', function(Blueprint $table) {
			$table->dropForeign('conseiller_pret_pret_id_foreign');
		});
		Schema::table('conseiller_pret', function(Blueprint $table) {
			$table->dropForeign('conseiller_pret_conseiller_id_foreign');
		});
		Schema::table('compterendus', function(Blueprint $table) {
			$table->dropForeign('compterendus_sujet_id_foreign');
		});
		Schema::table('compterendus', function(Blueprint $table) {
			$table->dropForeign('compterendus_client_id_foreign');
		});
		Schema::table('compterendus', function(Blueprint $table) {
			$table->dropForeign('compterendus_partenaire_id_foreign');
		});
		Schema::table('telephones', function(Blueprint $table) {
			$table->dropForeign('telephones_client_id_foreign');
		});
		Schema::table('adresses', function(Blueprint $table) {
			$table->dropForeign('adresses_client_id_foreign');
		});
		Schema::table('affectations', function(Blueprint $table) {
			$table->dropForeign('affectations_passif_id_foreign');
		});
		Schema::table('affectations', function(Blueprint $table) {
			$table->dropForeign('affectations_actif_id_foreign');
		});
		Schema::table('affectations', function(Blueprint $table) {
			$table->dropForeign('affectations_tresorerie_id_foreign');
		});
		Schema::table('affectations', function(Blueprint $table) {
			$table->dropForeign('affectations_id_client_foreign');
		});
		Schema::table('parentes', function(Blueprint $table) {
			$table->dropForeign('parentes_client_id_foreign');
		});
		Schema::table('client_regime', function(Blueprint $table) {
			$table->dropForeign('client_regime_client_id_foreign');
		});
		Schema::table('client_regime', function(Blueprint $table) {
			$table->dropForeign('client_regime_regime_id_foreign');
		});
		Schema::table('client_profession', function(Blueprint $table) {
			$table->dropForeign('client_profession_client_id_foreign');
		});
		Schema::table('client_profession', function(Blueprint $table) {
			$table->dropForeign('client_profession_profession_id_foreign');
		});
		Schema::table('courriels', function(Blueprint $table) {
			$table->dropForeign('courriels_client_id_foreign');
		});
		Schema::table('perimetres', function(Blueprint $table) {
			$table->dropForeign('perimetres_conseiller_id_foreign');
		});
		Schema::table('bien_client', function(Blueprint $table) {
			$table->dropForeign('bien_client_client_id_foreign');
		});
		Schema::table('bien_client', function(Blueprint $table) {
			$table->dropForeign('bien_client_bien_id_foreign');
		});
		Schema::table('conseillers', function(Blueprint $table) {
			$table->dropForeign('conseillers_preteur_id_foreign');
		});
		Schema::table('notaires', function(Blueprint $table) {
			$table->dropForeign('notaires_etude_id_foreign');
		});
		Schema::table('prets', function(Blueprint $table) {
			$table->dropForeign('prets_bien_id_foreign');
		});
		Schema::table('passifs', function(Blueprint $table) {
			$table->dropForeign('passifs_actif_id_foreign');
		});
		Schema::table('tresoreries', function(Blueprint $table) {
			$table->dropForeign('tresoreries_actif_id_foreign');
		});
		Schema::table('tresoreries', function(Blueprint $table) {
			$table->dropForeign('tresoreries_passif_id_foreign');
		});
	}
}