<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class LawyerOffer extends Eloquent {

	protected $table = 'lawyer_offer';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function lawyer()
	{
		return $this->belongsTo('Lawyer');
	}

	public function detail()
	{
		return $this->hasMany('LawyerOfferDetail');
	}

}