<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductStoreItemTable extends Migration {

	public function up()
	{
		Schema::create('product_store_item', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('store_item_id')->unique()->unsigned();
			$table->integer('product_id')->unique()->unsigned();
			$table->enum('discount_type', array('"none"', '"percentage"', '"amount"'));
			$table->decimal('discount_amount', 8.2)->default('0.00');
			$table->integer('sort_order')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('product_store_item');
	}
}