<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminUsersTable extends Migration {

	public function up()
	{
		Schema::create('admin_users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 20)->nullable();
			$table->bigInteger('phone')->nullable();
			$table->string('email', 20)->nullable();
			$table->string('password', 50)->nullable();
			$table->smallInteger('status')->nullable();
			$table->bigInteger('role_id')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('admin_users');
	}
}