<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmployeeIdentity extends Model 
{

    protected $table = 'employee_identities';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function employee()
    {
        return $this->belongsTo('Employee', 'employee_id');
    }

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

}