<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Study extends Model 
{

    protected $table = 'studies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function employee()
    {
        return $this->belongsTo('Employee', 'employee_id');
    }

    public function academicAchievement()
    {
        return $this->belongsTo('AcademicAchievement', 'academic_achievement');
    }

}