<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class JobInformation extends Model 
{

    protected $table = 'job_informations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function employee()
    {
        return $this->belongsTo('Employee', 'employee_id');
    }

    public function structureType()
    {
        return $this->belongsTo('StructureType', 'structure_type_id');
    }

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

}