<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('employees', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 250);
			$table->string('second_name', 250);
			$table->string('third_name', 250);
			$table->string('fourth_name', 250);
			$table->string('family_name', 250);
			$table->date('birthdate')->nullable();
			$table->string('first_name_en', 150)->nullable();
			$table->string('second_name_en', 150)->nullable();
			$table->string('third_name_en', 150)->nullable();
			$table->string('fourth_name_en', 150)->nullable();
			$table->string('mother_first_name', 150)->nullable();
			$table->string('mother_second_name', 150)->nullable();
			$table->string('mother_third_name', 150)->nullable();
			$table->longText('image')->nullable();
			$table->smallInteger('active')->default('1');
			$table->string('email', 150)->nullable();
			$table->string('phone', 20)->nullable();
			$table->tinyInteger('gender')->unsigned()->default('1');
			$table->integer('nationality_id')->unsigned();
			$table->integer('country_id')->unsigned()->default('1');
			$table->integer('category_id')->unsigned();
			$table->smallInteger('blood_type');
			$table->integer('nationalism_id')->unsigned()->default('1');
			$table->tinyInteger('marital_status');
			$table->integer('classification_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('employees');
	}
}