<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('nationality_id')->references('id')->on('nationalitys')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countrys')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('nationalism_id')->references('id')->on('nationalisms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('classification_id')->references('id')->on('classifications')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('studies', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('studies', function(Blueprint $table) {
			$table->foreign('academic_achievement_id')->references('id')->on('academic_achievements')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('academic_title', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('employee_identities', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('employee_identities', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('job_informations', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('job_informations', function(Blueprint $table) {
			$table->foreign('structure_type_id')->references('id')->on('structure_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_nationality_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_country_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_category_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_nationalism_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_classification_id_foreign');
		});
		Schema::table('studies', function(Blueprint $table) {
			$table->dropForeign('studies_employee_id_foreign');
		});
		Schema::table('studies', function(Blueprint $table) {
			$table->dropForeign('studies_academic_achievement_id_foreign');
		});
		Schema::table('academic_title', function(Blueprint $table) {
			$table->dropForeign('academic_title_employee_id_foreign');
		});
		Schema::table('employee_identities', function(Blueprint $table) {
			$table->dropForeign('employee_identities_employee_id_foreign');
		});
		Schema::table('employee_identities', function(Blueprint $table) {
			$table->dropForeign('employee_identities_category_id_foreign');
		});
		Schema::table('job_informations', function(Blueprint $table) {
			$table->dropForeign('job_informations_employee_id_foreign');
		});
		Schema::table('job_informations', function(Blueprint $table) {
			$table->dropForeign('job_informations_structure_type_id_foreign');
		});
	}
}