<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Employee extends Eloquent {

	protected $table = 'employees';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function nationality()
	{
		return $this->belongsTo('Nationality', 'nationality_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

	public function nationalism()
	{
		return $this->belongsTo('Nationalism', 'nationalism_id');
	}

	public function classification()
	{
		return $this->belongsTo('Classification', 'group_id');
	}

}