<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class JobInformation extends Eloquent {

	protected $table = 'job_informations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function employee()
	{
		return $this->belongsTo('Employee', 'employee_id');
	}

	public function structureType()
	{
		return $this->belongsTo('StructureType', 'structure_type_id');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

}