<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmpresasTable extends Migration {

	public function up()
	{
		Schema::create('empresas', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('socio_id')->unsigned()->nullable();
			$table->string('codigo');
			$table->string('cnpj', 18)->unique()->nullable();
			$table->string('razao_social');
			$table->string('fantasia')->nullable();
			$table->string('logo')->nullable();
			$table->enum('tributacao', array('SIMPLESNACIONAL', 'LUCROREAL', 'LUCROPRESUMIDO', 'IMUNE/ISENTA'));
			$table->string('cep')->nullable();
			$table->string('endereco')->nullable();
			$table->string('numero')->nullable();
			$table->string('bairro')->nullable();
			$table->string('cidade')->nullable();
			$table->string('uf')->nullable();
			$table->string('whatsapp', 20)->nullable();
			$table->string('celular', 20)->nullable();
			$table->string('telefone', 20)->nullable();
			$table->string('email', 100)->nullable();
			$table->string('site', 100)->nullable();
			$table->enum('ativo', array('S', 'N'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('empresas');
	}
}