<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('email', 191)->unique();
			$table->string('password');
			$table->string('foto')->nullable()->default('img/usuario/default.png');
			$table->enum('acesso', array(''admin'', ''usuario'', ''visitante''));
			$table->enum('ativo', array('S', 'N'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}