<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContratosTable extends Migration {

	public function up()
	{
		Schema::create('contratos', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('empresa_id')->unsigned();
			$table->string('nome');
			$table->enum('tipo', array('Básico', 'Médio', 'Total'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('contratos');
	}
}