<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('empresas', function(Blueprint $table) {
			$table->foreign('socio_id')->references('id')->on('socios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('movimentos', function(Blueprint $table) {
			$table->foreign('empresa_id')->references('id')->on('empresas')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('movimentos', function(Blueprint $table) {
			$table->foreign('periodo_id')->references('id')->on('periodos')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('movimentos', function(Blueprint $table) {
			$table->foreign('obrigacao_id')->references('id')->on('obrigacoes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('socios', function(Blueprint $table) {
			$table->foreign('empresa_id')->references('id')->on('empresas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contratos', function(Blueprint $table) {
			$table->foreign('empresa_id')->references('id')->on('empresas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('logs', function(Blueprint $table) {
			$table->foreign('usuario_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('empresas', function(Blueprint $table) {
			$table->dropForeign('empresas_socio_id_foreign');
		});
		Schema::table('movimentos', function(Blueprint $table) {
			$table->dropForeign('movimentos_empresa_id_foreign');
		});
		Schema::table('movimentos', function(Blueprint $table) {
			$table->dropForeign('movimentos_periodo_id_foreign');
		});
		Schema::table('movimentos', function(Blueprint $table) {
			$table->dropForeign('movimentos_obrigacao_id_foreign');
		});
		Schema::table('socios', function(Blueprint $table) {
			$table->dropForeign('socios_empresa_id_foreign');
		});
		Schema::table('contratos', function(Blueprint $table) {
			$table->dropForeign('contratos_empresa_id_foreign');
		});
		Schema::table('logs', function(Blueprint $table) {
			$table->dropForeign('logs_usuario_id_foreign');
		});
	}
}