<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMovimentosTable extends Migration {

	public function up()
	{
		Schema::create('movimentos', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('empresa_id')->unsigned();
			$table->integer('periodo_id')->unsigned();
			$table->integer('obrigacao_id')->unsigned();
			$table->enum('ativo', array('S', 'N'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('movimentos');
	}
}