<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateObrigacoesTable extends Migration {

	public function up()
	{
		Schema::create('obrigacoes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('nome');
			$table->enum('periodicidade', array('SEMANAL', 'QUINZENAL', 'MENSAL', 'TRIMESTRAL', 'SEMESTRAL', 'ANUAL'));
			$table->enum('area', array(''DP'', ''FISCAL'', ''CONTÁBIL'', ''LEGAISESOCIETÁRIOS''));
			$table->enum('ativo', array('S', 'N'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('obrigacoes');
	}
}