<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWebservicesTable extends Migration {

	public function up()
	{
		Schema::create('webservices', function(Blueprint $table) {
			$table->increments('id');
			$table->json('title');
			$table->string('description', 300);
			$table->string('logo', 150);
			$table->boolean('is_active')->default(1);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('webservices');
	}
}