<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCreditsTable extends Migration {

	public function up()
	{
		Schema::create('credits', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unique()->unsigned();
			$table->bigInteger('remaining_money');
			$table->date('date_create')->nullable();
			$table->date('date_last_charge')->nullable();
			$table->json('bank_information')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('credits');
	}
}