<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class List extends Eloquent {

	protected $table = 'lists';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'shop_id');

	public function shop()
	{
		return $this->belongsTo('Shop');
	}

	public function items()
	{
		return $this->hasMany('Item');
	}

}