<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('first_name', 'last_name', 'email', 'account_balance');

	public function shops()
	{
		return $this->hasMany('Shop');
	}

	public function months()
	{
		return $this->hasMany('Month');
	}

}