<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePricingRequestsTable extends Migration {

	public function up()
	{
		Schema::create('pricing_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('storage_duration_id')->unsigned();
			$table->tinyInteger('request_type');
			$table->timestamp('start_date');
			$table->softDeletes();
			$table->integer('storage_type_id')->unsigned();
			$table->integer('count');
			$table->string('coding')->nullable();
			$table->integer('technical_integration')->nullable();
			$table->string('packaging_method');
			$table->integer('deal_status');
			$table->integer('account_status');
			$table->integer('discount_request');
			$table->string('discount_request_status');
			$table->integer('price');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('pricing_requests');
	}
}