<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('pricing_requests', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pricing_requests', function(Blueprint $table) {
			$table->foreign('storage_duration_id')->references('id')->on('storage_durations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pricing_requests', function(Blueprint $table) {
			$table->foreign('storage_type_id')->references('id')->on('storage_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pricing_requests_matrials_types', function(Blueprint $table) {
			$table->foreign('pricing_request_id')->references('id')->on('pricing_requests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pricing_requests_matrials_types', function(Blueprint $table) {
			$table->foreign('matrial_type_id')->references('id')->on('matrial_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('request_pricing_services', function(Blueprint $table) {
			$table->foreign('pricing_request_id')->references('id')->on('pricing_requests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('request_pricing_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('pricing_requests', function(Blueprint $table) {
			$table->dropForeign('pricing_requests_user_id_foreign');
		});
		Schema::table('pricing_requests', function(Blueprint $table) {
			$table->dropForeign('pricing_requests_storage_duration_id_foreign');
		});
		Schema::table('pricing_requests', function(Blueprint $table) {
			$table->dropForeign('pricing_requests_storage_type_id_foreign');
		});
		Schema::table('pricing_requests_matrials_types', function(Blueprint $table) {
			$table->dropForeign('pricing_requests_matrials_types_pricing_request_id_foreign');
		});
		Schema::table('pricing_requests_matrials_types', function(Blueprint $table) {
			$table->dropForeign('pricing_requests_matrials_types_matrial_type_id_foreign');
		});
		Schema::table('request_pricing_services', function(Blueprint $table) {
			$table->dropForeign('request_pricing_services_pricing_request_id_foreign');
		});
		Schema::table('request_pricing_services', function(Blueprint $table) {
			$table->dropForeign('request_pricing_services_service_id_foreign');
		});
	}
}